#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#define SIZE		(1 * 1024 * 1024)

size_t filter(unsigned char *out, unsigned char *in, size_t n)
{
	size_t s = 0;

	unsigned char keep[256];

	keep[0] = 0;
	for (size_t c = 1; c < 256; c++) {
		keep[c] = ((873248763249102240 % c) == 0);
	}

	for (size_t j = 0; j < n; j++) {
		unsigned char c = in[j];

		if (c == 0)
			continue;

		out[s] = c;

		// keep only divisors of 873248763249102240
		s += keep[c];
	}

	return s;
}







int main(void)
{
	static unsigned char input[SIZE];
	static unsigned char output[SIZE];

	while (1) {
		size_t in_bytes = fread(input, 1, SIZE, stdin);

		if (in_bytes == 0)
			break;

		size_t out_bytes = filter(output, input, in_bytes);

		if (fwrite(output, out_bytes, 1, stdout) != 1) {
			perror("fwrite()");
			return 1;
		}
	}

	return 0;
}
