#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#define REPEAT	1

float *matrix_alloc(size_t size)
{
	float *a = malloc(sizeof(float) * size * size);

	if (a == NULL) {
		perror("matrix_alloc()");
		exit(1);
	}

	return a;
}

void matrix_random(size_t size, float *a)
{
	static uint64_t r = 0x92a834c7df2e983d;

	for (size_t i = 0; i < size; i++) {
		for (size_t j = 0; j < size; j++) {
			r = (r * 25214903917 + 11) & 0xffffffffffff;
			a[i * size + j] = (float)(r >> 16) / (float)0xffffffff;
		}
	}
}

float matrix_sum(size_t size, const float *a)
{
	float sum = 0.0;

	for (size_t i = 0; i < size; i++) {
		for (size_t j = 0; j < size; j++) {
			sum += a[i * size + j];
		}
	}

	return sum;
}

void matrix_multiply(size_t size, float *x, const float *a, const float *b)
{
	for (size_t i = 0; i < size; i++) {
		for (size_t j = 0; j < size; j++) {
			float sum = 0.0;
			for (size_t k = 0; k < size; k++) {
				sum += a[i * size + k] * b[k * size + j];
			}
			x[i * size + j] = sum;
		}
	}
}

int main(int argc, char **argv)
{
	if (argc != 2) {
		printf("Usage: %s [size]\n", argv[0]);
		return 1;
	}

	size_t size = strtol(argv[1], NULL, 0);

	if (size <= 0)
		return 1;

	float *a = matrix_alloc(size);
	float *b = matrix_alloc(size);
	float *x = matrix_alloc(size);

	matrix_random(size, a);
	matrix_random(size, b);

	for (int r = 0; r < REPEAT; r++) {
		matrix_multiply(size, x, a, b);
	}

	printf("%g\n", matrix_sum(size, x));

	free(a);
	free(b);
	free(x);

	return 0;
}
